/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.FiscalidadInternacional;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.ClienteExportacion;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PagoLocalExterior
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<PagoLocalExterior>,
Exportable,
Importable {
    private static final long serialVersionUID = -89617237877110130L;
    public static final String C_CONVENIO_TRIBUTACION = "convenioDobleTributacion";
    public static final String C_SUJETO_NORMA_LEGAL = "sujetoNormaLegal";
    public static final String C_VALOR_LOCAL = "NA";
    public static final String C_PAGO_REGIMEN_FISCAL = "pagoRegFiscal";
    public static final String C_TIPO_REGIMEN_FISCAL_EXTERIOR = "tipoRegimenFiscalExterior";
    private FiscalidadInternacional fiscalidad;
    private boolean convenioDobleTributacion;
    private boolean sujetoNormaLegal;
    private boolean pagoRegimenFiscal;
    private boolean exportacion;

    public PagoLocalExterior() {
        this.convenioDobleTributacion = true;
        this.sujetoNormaLegal = false;
        this.fiscalidad = new FiscalidadInternacional();
        this.fiscalidad.setPropietario((ObjetoModelo)this);
    }

    public PagoLocalExterior(boolean exportacion) {
        this.exportacion = exportacion;
        this.convenioDobleTributacion = true;
        this.sujetoNormaLegal = false;
        this.fiscalidad = new FiscalidadInternacional();
        this.fiscalidad.setExportacion(exportacion);
        this.fiscalidad.setPropietario((ObjetoModelo)this);
    }

    protected ResultadoValidacion validarObjeto() {
        boolean esExportaciones;
        ResultadoValidacion resultado = new ResultadoValidacion();
        resultado = this.getFiscalidad().validarObjeto();
        Periodo periodo = ((Iva)this.getRaizModelo()).periodo;
        boolean bl = esExportaciones = ((PagoLocalExterior)this.fiscalidad.getPropietario()).getPropietario() instanceof ClienteExportacion;
        if (this.fiscalidad.getTipoRegimenFiscalExterior() != null && "01".equals(this.fiscalidad.getTipoRegimenFiscalExterior()) && !this.sujetoNormaLegal && periodo.isPeriodoDesdeEnero2018() && !esExportaciones) {
            return resultado.pasarValidacionAdvertencia("Si el pago al exterior aplicando convenios de doble tributaci\u00f3n corresponde a un gasto deducible y sobrepasa las 20 fracciones b\u00e1sicas desgravadas deber\u00e1 retenerse el 22%");
        }
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public PagoLocalExterior crearCopiaEdicion() {
        PagoLocalExterior copia = new PagoLocalExterior();
        FiscalidadInternacional copiaFiscalidad = new FiscalidadInternacional();
        copiaFiscalidad = this.getFiscalidad().crearCopiaEdicion();
        copia.setFiscalidad(copiaFiscalidad);
        copia.setConvenioDobleTributacion(this.convenioDobleTributacion);
        copia.setSujetoNormaLegal(this.sujetoNormaLegal);
        copia.setPagoRegimenFiscal(this.pagoRegimenFiscal);
        copia.setPropietario(this.propietario);
        return copia;
    }

    public void actualizarInformacion(PagoLocalExterior copiaEdicion) {
        this.setFiscalidad(copiaEdicion.getFiscalidad());
        this.setConvenioDobleTributacion(copiaEdicion.isConvenioDobleTributacion());
        this.setSujetoNormaLegal(copiaEdicion.isSujetoNormaLegal());
        this.setPagoRegimenFiscal(copiaEdicion.isPagoRegimenFiscal());
    }

    public void limpiarDatos(Periodo periodo, boolean esPagoAResidente) {
        if (esPagoAResidente) {
            if (periodo.isAnexoEnPeriodoDesdeMayo2016()) {
                this.getFiscalidad().setTipoRegimenFiscalExterior(null);
                this.getFiscalidad().setPaisRegimenGeneral(null);
                this.getFiscalidad().setDescripcionPaisRegimenGeneral(null);
                this.getFiscalidad().setPaisParaisoFiscal(null);
                this.getFiscalidad().setDescripcionPaisParaisoFiscal(null);
            }
            this.getFiscalidad().setPaisPago(null);
        }
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("pagoLocExt");
        Element eValor = (Element)valorList.item(0);
        this.fiscalidad = (FiscalidadInternacional)((Object)this.getFiscalidad().importar(elemento, mapaData));
        if (!"01".equals(this.getFiscalidad().getTipoPago())) {
            valorList = elemento.getElementsByTagName("aplicConvDobTrib");
            eValor = (Element)valorList.item(0);
            this.convenioDobleTributacion = Util.importarBooleano(eValor);
            valorList = elemento.getElementsByTagName("pagExtSujRetNorLeg");
            eValor = (Element)valorList.item(0);
            this.sujetoNormaLegal = Util.importarBooleano(eValor);
            valorList = elemento.getElementsByTagName("pagoRegFis");
            eValor = (Element)valorList.item(0);
            if (eValor != null) {
                this.pagoRegimenFiscal = Util.importarBooleano(eValor);
            }
        }
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element elmPgExt = documento.createElement("pagoExterior");
        Periodo periodo = ((Iva)this.getRaizModelo()).periodo;
        Element em = documento.createElement("pagoLocExt");
        elmPgExt = this.getFiscalidad().exportar(documento, null);
        em = documento.createElement("paisEfecPago");
        em.setTextContent("01".equals(this.fiscalidad.getTipoPago()) ? C_VALOR_LOCAL : this.fiscalidad.getPaisPago());
        elmPgExt.appendChild(em);
        em = documento.createElement("aplicConvDobTrib");
        em.setTextContent("01".equals(this.fiscalidad.getTipoPago()) ? C_VALOR_LOCAL : this.getConvenioDobleTributacion());
        elmPgExt.appendChild(em);
        em = documento.createElement("pagExtSujRetNorLeg");
        em.setTextContent("01".equals(this.fiscalidad.getTipoPago()) || this.isConvenioDobleTributacion() ? C_VALOR_LOCAL : this.getSujetoNormaLegal());
        elmPgExt.appendChild(em);
        if (periodo.isPeriodoDeAnexoDesdeMarzo2015() && periodo.isAnexoEnPeriodoHastaAbril2016()) {
            em = documento.createElement("pagoRegFis");
            em.setTextContent("01".equals(this.fiscalidad.getTipoPago()) ? C_VALOR_LOCAL : this.getPagoRegimenFiscal());
            elmPgExt.appendChild(em);
        }
        return elmPgExt;
    }

    public boolean isConvenioDobleTributacion() {
        return this.convenioDobleTributacion;
    }

    public String getConvenioDobleTributacion() {
        return this.convenioDobleTributacion ? "SI" : "NO";
    }

    public boolean isSujetoNormaLegal() {
        return this.sujetoNormaLegal;
    }

    public String getSujetoNormaLegal() {
        return this.sujetoNormaLegal ? "SI" : "NO";
    }

    public String getPagoRegimenFiscal() {
        return this.pagoRegimenFiscal ? "SI" : "NO";
    }

    public boolean isPagoRegimenFiscal() {
        return this.pagoRegimenFiscal;
    }

    public FiscalidadInternacional getFiscalidad() {
        return this.fiscalidad;
    }

    public void setConvenioDobleTributacion(boolean convenioDobleTributacion) {
        boolean oldValue = this.convenioDobleTributacion;
        this.convenioDobleTributacion = convenioDobleTributacion;
        this.firePropertyChange(C_CONVENIO_TRIBUTACION, oldValue, this.convenioDobleTributacion);
    }

    public void setSujetoNormaLegal(boolean sujetoNormaLegal) {
        boolean oldValue = this.sujetoNormaLegal;
        this.sujetoNormaLegal = sujetoNormaLegal;
        this.firePropertyChange(C_SUJETO_NORMA_LEGAL, oldValue, this.sujetoNormaLegal);
    }

    public void setPagoRegimenFiscal(boolean pagoRegimenFiscal) {
        boolean oldValue = this.pagoRegimenFiscal;
        this.pagoRegimenFiscal = pagoRegimenFiscal;
        this.firePropertyChange(C_PAGO_REGIMEN_FISCAL, oldValue, this.pagoRegimenFiscal);
    }

    public boolean isExportacion() {
        return this.exportacion;
    }

    public void setExportacion(boolean exportacion) {
        this.exportacion = exportacion;
    }

    public void setFiscalidad(FiscalidadInternacional fiscalidad) {
        this.fiscalidad = fiscalidad;
    }
}

